@if ($paginator->hasPages())
    <div class="row mt-4" dir="ltr">
        <div class="col-12 d-flex justify-content-center">
            <div class="dataTables_paginate paging_simple_numbers">
                <ul class="pagination">
                    {{-- Previous Page Link --}}
                    @if ($paginator->onFirstPage())
                        <li class="paginate_button page-item previous disabled">
                            <a href="#" class="page-link" style="color: #36304a;">{{ __('Previous') }}</a>
                        </li>
                    @else
                        <li class="paginate_button page-item previous">
                            <a href="{{ $paginator->previousPageUrl() }}" class="page-link" style="color: #36304a;">{{ __('Previous') }}</a>
                        </li>
                    @endif

                    {{-- Pagination Elements --}}
                    @foreach ($elements as $element)
                        @if (is_string($element))
                            <li class="paginate_button page-item disabled">
                                <a href="#" class="page-link" style="color: #36304a;">{{ $element }}</a>
                            </li>
                        @endif

                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <li class="paginate_button page-item active">
                                        <a href="#" class="page-link" style="background-color: #36304a; border-color: #36304a; color: #fff;">{{ $page }}</a>
                                    </li>
                                @else
                                    <li class="paginate_button page-item">
                                        <a href="{{ $url }}" class="page-link" style="color: #36304a;">{{ $page }}</a>
                                    </li>
                                @endif
                            @endforeach
                        @endif
                    @endforeach

                    {{-- Next Page Link --}}
                    @if ($paginator->hasMorePages())
                        <li class="paginate_button page-item next">
                            <a href="{{ $paginator->nextPageUrl() }}" class="page-link" style="color: #36304a;">{{ __('Next') }}</a>
                        </li>
                    @else
                        <li class="paginate_button page-item next disabled">
                            <a href="#" class="page-link" style="color: #36304a;">{{ __('Next') }}</a>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>

    <div class="row mt-2" dir="ltr">
        <div class="col-12 d-flex justify-content-center">
            <div class="dataTables_info" role="status" aria-live="polite" style="color: #36304a;">
                {!! __('Showing') !!}
                @if ($paginator->firstItem())
                    {{ $paginator->firstItem() }} {!! __('to') !!} {{ $paginator->lastItem() }}
                @else
                    {{ $paginator->count() }}
                @endif
                {!! __('of') !!} {{ $paginator->total() }} {!! __('results') !!}
            </div>
        </div>
    </div>
@endif
