<?php

use App\Http\Controllers\API\ThirdPartyController;
use App\Http\Controllers\API\V2\ThirdPartyController as ThirdPartyControllerV2;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\ReportController;
use App\Http\Controllers\API\StudentController;
use App\Http\Controllers\API\StudentPaymentController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('student')->group(function () {
    Route::post('student-info', [StudentController::class, 'studentInfo']);
    Route::post('add-payment', [StudentPaymentController::class, 'addPayment']);
});

Route::controller(AuthController::class)->group(function(){
    Route::post('register', 'register');
    Route::post('login', 'login');
});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('logout', [AuthController::class, 'logout']);
    Route::prefix('report')->group(function () {
        Route::get('filter-options', [ReportController::class,'filterOptions']);
        Route::get('payments', [ReportController::class,'payments']);
    });
});

Route::post('students/details', [StudentPaymentController::class, 'studentDetails']);


// Todo: delete
route::get('test-api', function() {
    return \App\Helpers\ApiHelper::hasAppAccount(2211133812);
});

Route::prefix('third-party/students')->group(function () {
    Route::post('student-info', [ThirdPartyController::class, 'studentInfo']);
    Route::post('add-payment', [ThirdPartyController::class, 'addPayment']);
});

Route::prefix('v2/third-party/students')->group(function () {
    Route::post('student-info', [ThirdPartyControllerV2::class, 'studentInfo']);
    Route::post('add-payment', [ThirdPartyControllerV2::class, 'addPayment']);
});
