<?php

use App\Models\Payment;
use App\Models\Student;
use App\Models\Registration;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\FeeController;
use App\Http\Controllers\API\AmarousPayController;
use App\Http\Controllers\Dashboard\FileController;
use App\Http\Controllers\Dashboard\UserController;
use App\Http\Controllers\Dashboard\QrCodeController;
use App\Http\Controllers\Dashboard\ReportController;
use App\Http\Controllers\Dashboard\StudentController;
use App\Http\Controllers\Dashboard\OtherFeeController;
use App\Http\Controllers\Dashboard\PrintOutController;
use App\Http\Controllers\Dashboard\SettingsController;
use App\Http\Controllers\Dashboard\AttendanceController;
use App\Http\Controllers\Dashboard\ActivityLogController;
use App\Http\Controllers\Dashboard\StudentCardController;
use App\Http\Controllers\Dashboard\ExportImportController;
use App\Http\Controllers\Dashboard\RegistrationController;

use App\Http\Controllers\Dashboard\TestimoIcateController;
use App\Http\Controllers\Dashboard\RegistrationConstraintController;
use App\Http\Controllers\API\StudentController as APIStudentController;
use App\Http\Controllers\Dashboard\AmarousPayController as WebAmarousPayController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::get('api/get-student-info', [APIStudentController::class, 'getStudentInfo']);

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::middleware(['auth'])->group(function () {
    Route::get('student', [StudentController::class, 'index'])->name('student.index');
    Route::get('student/payments', [StudentController::class, 'payments'])->name('student.payments');
    Route::get('/students/search', [StudentController::class, 'search'])->name('students.search');
    Route::resource('student', StudentController::class);

    Route::post('student/import/',[ExportImportController::class,'importStudent'])->name('student.import');
    Route::post('student/payment/import/',[ExportImportController::class,'importStudentPayment'])->name('student.payment.import');
    Route::get('student/payment/export/',[ExportImportController::class,'exportStudentPayment'])->name('student.payment.export');
    Route::get('student/export/',[ExportImportController::class,'exportStudent'])->name('student.export');
    Route::get('student/export/view',[ExportImportController::class,'exportStudentsView'])->name('student.export.view');
    Route::get('student/payment/export/view',[ExportImportController::class,'exportStudentsPaymentsView'])->name('students.payments.export.view');

    // Route::resource('student', StudentController::class);
//    Route::get('student/payment/file-import',[ExportImportController::class,'importStudentPaymenView'])->name('student.payment.import-view');
//    Route::get('student/file-import',[ExportImportController::class,'importStudentView'])->name('student.import-view');


    Route::get('testimo-icate', [TestimoIcateController::class, 'index'])->name('testimonies-certificates');
    Route::get('settings', [SettingsController::class, 'index'])->name('settings');

    Route::get('reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('reports/payments', [ReportController::class, 'payments'])->name('reports.payments');
    Route::get('reports/fees', [ReportController::class, 'fees'])->name('reports.fees');
    Route::get('reports/revenues', [ReportController::class, 'revenues'])->name('reports.revenues');
    Route::get('reports/revenues-min', [ReportController::class, 'revenuesMin'])->name('reports.revenue-min');
    Route::get('reports/fees/{studentId}',[ReportController::class, 'showStudentFees'])->name('reports.show.fees');
    Route::get('payments/{studentId}',[ReportController::class, 'showStudentPayments'])->name('payments.show');

    Route::get('settings/registration-constraint', [RegistrationConstraintController::class, 'index'])->name('settings.registration.constraint');
    Route::get('settings/registration-constraint/{id}/show', [RegistrationConstraintController::class, 'show'])->name('settings.registration.constraint.show');
    Route::post('settings/registration-constraint', [RegistrationConstraintController::class, 'store'])->name('settings.registration.constraint.store');
    Route::put('settings/registration-constraint/{id}', [RegistrationConstraintController::class, 'update'])->name('settings.registration.constraint.update');
    Route::delete('settings/registration-constraint/{id}', [RegistrationConstraintController::class, 'destroy'])->name('settings.registration.constraint.destroy');

    Route::get('settings/setup-registration', [RegistrationController::class, 'index'])->name('settings.setup.registration');
    // Route::resource('settings/registration-constraint', RegistrationConstraintController::class);
    // Route::post('settings/setup-registration', [SettingsController::class, 'postSetupRegistration'])->name('settings.setup.registration');
    Route::put('settings/activate-registration/{settingsName}', [SettingsController::class, 'activateRegistration'])->name('settings.activate.registration');
    Route::put('settings/deactivate-registration/{settingsName}', [SettingsController::class, 'deactivateRegistration'])->name('settings.deactivate.registration');
    Route::get('settings/setup-penalty', [SettingsController::class, 'setupPenalty'])->name('settings.setup.penalty');
    Route::post('settings/setup-penalty', [SettingsController::class, 'postPenalty'])->name('post.settings.setup.penalty');
    Route::put('settings/edit-penalty/{penaltyId}', [SettingsController::class, 'editPenalty'])->name('settings.edit.penalty');
    Route::delete('settings/delete-penalty/{penaltyId}', [SettingsController::class, 'deletePenalty'])->name('settings.delete.penalty');

    Route::get('settings/sort-students', [SettingsController::class, 'sortStudents'])->name('settings.sort.students');
    Route::put('settings/update-sort-students', [SettingsController::class, 'updateSortStudents'])->name('settings.update.sort.students');

    Route::post('upload/image', [StudentController::class, 'uploadImage'])->name('upload.image');

    Route::resource('fee', FeeController::class);
//    Route::get('fee/create/{studentId}', FeeController::class, 'create')->name('fee.create');
    Route::get('fee/create/{studentId}', FeeController::class, 'create')->name('fee.create.student');

    Route::resource('/other-fee', OtherFeeController::class);

    Route::get('/user-profile', [UserController::class, 'profile'])->name('user.profile');
    Route::put('/user-profile/update', [UserController::class, 'updateProfile'])->name('user.profile.update');
    Route::resource('user', UserController::class);


    Route::get('attendance/classes-attendance-sheet', [AttendanceController::class, 'classesAttendanceSheet'])->name('attendances.classes-attendance-sheet');
    Route::get('attendance/exams-attendance-sheet', [AttendanceController::class, 'examsAttendanceSheet'])->name('attendances.exams-attendance-sheet');

    Route::resource('registration', RegistrationController::class);

    Route::get('settings/activity-log', [ActivityLogController::class, 'index'])->name('settings.activity-log');


});

//Route::get('insert-data', [StudentController::class, 'insertData']);
//Route::any('filter-students', [StudentController::class, 'filterStudents'])->name('filter.students');
//Route::any('filter-students-payments', [StudentController::class, 'filterStudentPayment'])->name('filter.students.payments');
//Route::any('filter-students-fees', [FeeController::class, 'filterStudentFees'])->name('filter.students.fees');
//Route::any('reports/filter-students-payments-report', [ReportController::class, 'filterStudentPaymentReport'])->name('filter.students.payments.report');
//Route::any('reports/filter-students-fees-report', [ReportController::class, 'filterStudentFeeReport'])->name('filter.students.fees.report');
//Route::any('reports/filter-students-revenues-report', [ReportController::class, 'filterStudentRevenueReport'])->name('filter.students.revenues.report');
//Route::any('reports/filter-students-revenues-min-report', [ReportController::class, 'filterStudentRevenueMinReport'])->name('filter.students.revenues.min.report');
//Route::any('registration-filter-students', [RegistrationController::class, 'filterStudentsRegistration'])->name('registration.filter.students');

Route::get('college-sections', [StudentController::class,'getCollegeSections'])->name('college.sections');

Route::get('semester-payments-number', [FeeController::class,'getSemesterPaymentsNumber'])->name('semester.payments.number');

Route::get('get-student-info', [StudentController::class,'getStudentInfo'])->name('get.student.info');
Route::get('pay-student-payment', [StudentController::class,'payStudentPayment'])->name('pay.student.payment');
Route::post('pay-payment', [StudentController::class,'payPayment'])->name('pay.payment');

Route::get('registration-management', [RegistrationController::class, 'manageRegistration'])->name('registration-management.index');
Route::get('registration-management/{id}/show', [RegistrationController::class, 'showRegistrationCollection'])->name('registration-management.show');
Route::get('registration-management/{id}/edit', [RegistrationController::class, 'editRegistrationCollection'])->name('registration-management.edit');
Route::put('registration-management', [RegistrationController::class, 'updateRegistrationCollection'])->name('registration-management.update');
Route::delete('registration-management/{id}', [RegistrationController::class, 'destroy'])->name('registration-management.destroy');

Route::get('registrar-print-out',[PrintOutController::class, 'registrarPrintOut'])->name('registrar.print.out');

Route::get('students/temp/info', function(){
    $students = Student::all();

    return view('temp-deleted/index', [
        'students' => $students
    ]);
})->name('students.info');

Route::get('redis-test', function(){
    $redis = Redis::connection();

    $students = Student::all();

    foreach ($students as $student) {
        $student['student_name'] = 'redis chaneged';
    }

    if(is_null($redis->get('students'))){
        $students = $students->toArray();
        $redis->set('students', json_encode($students));
        $students = collect($students);
    } else{
        $students = collect(json_decode($redis->get('students'), true));
    }

    return $students;
})->name('redis-test');

Route::get('check-receipt/{ref}', [QrCodeController::class, 'checkReciept'])->name('check.receipt');



//Activity Log
Route::get('settings/activity-log', [ActivityLogController::class, 'index'])->name('settings.activity-log');
//Route::any('settings/filter-activity-log', [ActivityLogController::class, 'filterActivities'])->name('settings.filter-activity-log');

Route::any('student/{id}/files', [StudentController::class, 'files'])->name('student.files');

Route::resource('student-files', FileController::class);

Route::any('/public', function(){
    return Redirect::to("https://payment.uofs.edu.sd/");
})->name('user');

Route::get('update-payments', function(){
    $payments = Payment::with('student')->get();

    foreach($payments as $payment){
        $payment['study_fees'] = $payment->student->program_fees > 0 ? $payment->student->program_fees/ 2 : 0;

        $payment->save();
    }

    return "done";
});

Route::any('/card-payment', [AmarousPayController::class, 'index'])->name('card-payment.index');
Route::post('amarous-pay/request', [WebAmarousPayController::class, 'paymentRequest']);
Route::post('amarous-pay/student-info', [WebAmarousPayController::class, 'getStudentInfo']);
Route::get('amarous-pay/sms-notification', [WebAmarousPayController::class, 'sendMessageNotification']);

Route::post('/exclude-student', [StudentController::class, 'excludeStudent'])->name('exclude.student');
Route::post('/included-students', [StudentController::class, 'includedStudents'])->name('included.students');

Route::post('/sort-table-by', [SettingsController::class, 'sortTable'])->name('sort.table.by');

// Student Card
Route::any('filter-students-cards', [StudentCardController::class, 'filterStudentsCards'])->name('filter.students.cards');
Route::any('students-cards/replace-lost', [StudentCardController::class, 'replaceLost'])->name('students-cards.replace-lost');
Route::any('filter-replace-lost-cards', [StudentCardController::class, 'filterReplaceLostCards'])->name('filter.students.replace-lost');

Route::post('print-card', [StudentCardController::class, 'printCard'])->name('print.card');
Route::post('print-card-front', [StudentCardController::class, 'printCardFront'])->name('print.card.front');
Route::post('print-card-back', [StudentCardController::class, 'printCardBack'])->name('print.card.back');

Route::resource('students-cards', StudentCardController::class);

Route::get('state-localities', [StudentController::class,'getStateLocalities'])->name('state.localities');

Route::get('/print-classes-sheet', [PrintOutController::class, 'classesSheet'])->name('print.classes.sheet');
Route::get('/print-exams-sheet', [PrintOutController::class, 'examsSheet'])->name('print.exams.sheet');
Route::get('/print-revenue-min', [PrintOutController::class, 'revenueMin'])->name('print.revenue-min');
