<div class="custom-filter row">
    <form action="<?php echo e(route(Route::currentRouteName())); ?>" method="get" id="filterForm">
        
        <div class="row flex justify-center space-x-2">
            <!--  الكلية -->
            <?php if(!auth()->user()->hasRole('registrar')): ?>
                <div class="col-2 px-1">
                    <select id="college" name="college_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="0"><?php echo e(__('student.choose-college')); ?></option>
                        <?php if( isset($colleges) ): ?>
                            <?php $__currentLoopData = $colleges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $college): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($college->id); ?>" <?php echo e(isset($filters->college_id) && $filters->college_id == $college->id ? 'selected' : ''); ?> class="college-options">
                                    <?php echo e($college->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
            <?php endif; ?>

            <!--  القسم -->
            <div class="col-2">
                <select id="section" name="section_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0"><?php echo e(__('student.choose-section')); ?></option>
                    <?php if( isset($sections) ): ?>
                        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($section->id); ?>" <?php echo e(isset($filters->section_id) && $filters->section_id == $section->id ? 'selected' : ''); ?>>
                                <?php echo e($section->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <!--  البرنامج -->
            <div class="col-2">
                <select id="program" name="program_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0"><?php echo e(__('student.choose-program')); ?></option>
                    <?php if( isset($programs) ): ?>
                        <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($program->id); ?>" <?php echo e(isset($filters->program_id) && $filters->program_id == $program->id ? 'selected' : ''); ?>>
                                <?php echo e($program->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <!-- الدفعة -->
            <div class="col-2">
                <select id="batch" name="batch_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    <option value="0"><?php echo e(__('student.choose-batch')); ?></option>
                    <?php if( isset($batches) ): ?>
                        <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($batch->id); ?>" <?php echo e(isset($filters->batch_id) && $filters->batch_id == $batch->id ? 'selected' : ''); ?>>
                                <?php echo e($batch->value); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <?php
                $includedRoutes = [
                    'fee.index'
                ];
            ?>

            <?php if(in_array(Route::currentRouteName(), $includedRoutes)): ?>
                <div class="col-2">
                    <select id="paymentCurrency" name="payment_currency"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm font-normal rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">

                        <option value="0" selected>كل العملات</option>
                        <option value="SDG" <?php echo e(isset($filters->payment_currency) && $filters->payment_currency == "SDG" ? 'selected' : ''); ?>>جنية سوداني</option>
                        <option value="USD" <?php echo e(isset($filters->payment_currency) && $filters->payment_currency == "USD" ? 'selected' : ''); ?>>دولار امريكي</option>

                    </select>
                </div>
            <?php endif; ?>

        </div>

        <!-- Special filter -->
        <?php if( Route::current()->getName() == 'reports.payments' || Route::current()->getName() == 'reports.revenues' ): ?>
            <?php echo $__env->make('layouts.special-filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if( Route::current()->getName() == 'reports.fees' || Route::current()->getName() == 'filter.students.revenues.report' ): ?>
            <?php echo $__env->make('layouts.special-filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>


        <div class="row flex justify-center space-x-2 mt-4">
            <div class="col-4 flex justify-center px-1">
                <button type="submit" style="background-color: #36304a;" class="mr-3 px-4 py-2 rounded-2 text-white btn" id="studentFilter" name="filter">
                    <?php echo e(__('student.apply-filter')); ?>

                </button>
                <a href="<?php echo e(route(Route::currentRouteName())); ?>" style="background-color: #36304a;" class="bg-danger btn mr-3 px-4 py-2 rounded-2 text-white" id="studentFilter">
                    <?php echo e(__('student.reset')); ?>

                </a>
            </div>
        </div>

        <?php echo $__env->make('students.partials.search-button', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </form>
</div>
<?php /**PATH /home/httpsunited/public_html/shemal.united.sd/resources/views/layouts/filter.blade.php ENDPATH**/ ?>