<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/custom-student-style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/custom-style.css')); ?>">
    <style>
        tfoot{
            background-color: #36304a;
        }

        table.dataTable>thead>tr>th:not(.sorting_disabled){
            padding-right: 30px !important;
        }
        .toast-title{
            text-align: center;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container main-container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card" id="content">
                <!-- this is where data loaded-->
                <?php echo $__env->yieldContent('card-content'); ?>
                <div class="card-header"><?php echo e(__('home.dashboard')); ?></div>


                <div class="card-body min-h-screen">
                    <?php if(session('status')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('status')); ?>

                    </div>
                    <?php endif; ?>

                    <div class="min-w-screen  bg-white flex items-center justify-center px-5 py-5">
                        <div class="row">
                        <?php if( auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin')): ?>
                            <div class="col-12">
                                <div class="-mx-2 md:flex">
                                    
                                    <div class="w-full md:w-1/4 px-2">
                                        <div class="rounded-lg shadow-sm mb-4">
                                            <div
                                                class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                                <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                    <h4 class="text-bg-primary uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                        <?php echo e(__('home.students-number')); ?>

                                                    </h4>
                                                    <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-primary">
                                                        <?php echo e($studentsNumber); ?>

                                                    </h3>

                                                    <h4 class="text-bg-primary uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                        <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                            <?php echo e(__('home.show-details')); ?>

                                                            <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                        </a>
                                                    </h4>
                                                    
                                                </div>
                                                <div class="absolute bottom-0 inset-x-0">
                                                    <canvas id="chart1" height="70"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="w-full md:w-1/4 px-2">
                                        <div class="rounded-lg shadow-sm mb-4">
                                            <div
                                                class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                                <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                    <h4 class="text-bg-success uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                        <?php echo e(__('home.registered-students')); ?>

                                                    </h4>
                                                    <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-success">
                                                        <?php echo e($registerdStudents); ?>

                                                    </h3>
                                                    <h4 class="text-bg-success uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                        <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                            <?php echo e(__('home.show-details')); ?>

                                                            <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                        </a>
                                                    </h4>
                                                    
                                                </div>
                                                <div class="absolute bottom-0 inset-x-0">
                                                    <canvas id="chart2" height="70"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="w-full md:w-1/4 px-2">
                                        <div class="rounded-lg shadow-sm mb-4">
                                            <div
                                                class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                                <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                    <h4 class="text-bg-warning uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                        <?php echo e(__('home.partially-registered-students')); ?>

                                                    </h4>
                                                    <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-warning">
                                                        <?php echo e($partiallyRegisteredStudents); ?>

                                                    </h3>
                                                    <h4 class="text-bg-warning uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                        <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                            <?php echo e(__('home.show-details')); ?>

                                                            <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                        </a>
                                                    </h4>
                                                    
                                                </div>
                                                <div class="absolute bottom-0 inset-x-0">
                                                    <canvas id="chart3" height="70"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="w-full md:w-1/4 px-2">
                                        <div class="rounded-lg shadow-sm mb-4">
                                            <div
                                                class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                                <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                    <h4 class="text-bg-danger uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                        <?php echo e(__('home.unregistered-students')); ?>

                                                    </h4>
                                                    <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-danger">
                                                        <?php echo e($unregisterdStudents); ?>

                                                    </h3>
                                                    <h4 class="text-bg-danger uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                        <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                            <?php echo e(__('home.show-details')); ?>

                                                            <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                        </a>
                                                    </h4>
                                                    
                                                </div>
                                                <div class="absolute bottom-0 inset-x-0">
                                                    <canvas id="chart3" height="70"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(auth()->user()->hasRole(['financial', 'admin']) && auth()->user()->payment_identifier == null): ?>
                        <div class="col-12">
                            <div class="-mx-2 md:flex">
                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <h4 class="text-bg-primary uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                    <?php echo e(__('home.total-income')); ?>

                                                </h4>
                                                <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-primary">
                                                    <?php echo e(number_format( $totalIncome )); ?>

                                                </h3>

                                                <h4 class="text-bg-primary uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                    <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                        <?php echo e(__('home.show-details')); ?>

                                                        <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                    </a>
                                                </h4>
                                                
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart1" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <h4 class="text-bg-success uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                    <?php echo e(__('home.total-paid')); ?>

                                                </h4>
                                                <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-success">
                                                    <?php echo e(number_format( $totalPaid )); ?>

                                                </h3>
                                                <h4 class="text-bg-success uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                    <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                        <?php echo e(__('home.show-details')); ?>

                                                        <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                    </a>
                                                </h4>
                                                
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <h4 class="text-bg-warning uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                    <?php echo e(__('home.total-amount')); ?>

                                                </h4>
                                                <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-warning">
                                                    <?php echo e(number_format( $totalAmount )); ?>

                                                </h3>
                                                <h4 class="text-bg-warning uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                    <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                        <?php echo e(__('home.show-details')); ?>

                                                        <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                    </a>
                                                </h4>
                                                
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart3" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <h4 class="text-bg-danger uppercase text-gray-500 leading-tight text-xl p-1 rounded-2">
                                                    <?php echo e(__('home.total-unpaid')); ?>

                                                </h4>
                                                <h3 class="text-3xl text-gray-700 font-semibold leading-tight my-3 text-danger">
                                                    <?php echo e(number_format( $totalUnpaid )); ?>

                                                </h3>
                                                <h4 class="text-bg-danger uppercase text-gray-500 leading-tight text-xl p-1 rounded-2 flex justify-between px-4">
                                                    <a href="#" onclick="alert('سيتم تفعيله قريباً');">
                                                        <?php echo e(__('home.show-details')); ?>

                                                        <i class="bg-white fa fa-arrow-left p-1 rounded-circle text-black" aria-hidden="true"></i>
                                                    </a>
                                                </h4>
                                                
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart3" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="-mx-2 md:flex">
                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <div class="bank-logo mb-2">
                                                    <img src="<?php echo e(asset('img/banks/ssd-bank-logo.png')); ?>" alt="">
                                                </div>
                                                <h3 class="text-3xl text-black font-semibold leading-tight my-3 text-success" style="background-color: rgba(0,0,0,0.1);">
                                                    <?php echo e($ssdBankRevenue ?? 0.0); ?>

                                                </h3>
                                                <h4 class="text-black leading-tight text-xl p-1 rounded-2" style="background-color: rgba(14,197,235, 0.5);">
                                                    إيرادات بنك الإدخار
                                                </h4>
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <div class="bank-logo mb-2">
                                                    <img src="<?php echo e(asset('img/banks/fcbsudan-logo.png')); ?>" alt="">
                                                </div>
                                                <h3 class="text-3xl text-black font-semibold leading-tight my-3 text-success" style="background-color: rgba(0,0,0,0.1);">
                                                    <?php echo e(isset($fcbSudanBankRevenue) ? $fcbSudanBankRevenue : 0.0); ?>

                                                </h3>
                                                <h4 class="text-black leading-tight text-xl p-1 rounded-2" style="background-color: rgba(14,197,235, 0.5);">
                                                    إيرادات بنك المزارع
                                                </h4>
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <div class="bank-logo mb-2">
                                                    <img src="<?php echo e(asset('img/banks/nb-logo.jpeg')); ?>" alt="">
                                                </div>
                                                <h3 class="text-3xl text-black font-semibold leading-tight my-3 text-success" style="background-color: rgba(0,0,0,0.1);">
                                                    <?php echo e(isset($nbBankRevenue) ? $nbBankRevenue : 0.0); ?>

                                                </h3>
                                                <h4 class="text-black leading-tight text-xl p-1 rounded-2" style="background-color: rgba(14,197,235, 0.5);">
                                                    إيرادات بنك النيل
                                                </h4>
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <div class="bank-logo mb-2">
                                                    <img src="<?php echo e(asset('img/banks/2nb-logo.jpg')); ?>" alt="">
                                                </div>
                                                <h3 class="text-3xl text-black font-semibold leading-tight my-3 text-success" style="background-color: rgba(0,0,0,0.1);">
                                                    <?php echo e(isset($_2nbBankRevenue) ? $_2nbBankRevenue : 0.0); ?>

                                                </h3>
                                                <h4 class="text-black leading-tight text-xl p-1 rounded-2" style="background-color: rgba(14,197,235, 0.5);">
                                                    إيرادات بنك النيلين
                                                </h4>
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="w-full md:w-1/4 px-2">
                                    <div class="rounded-lg shadow-sm mb-4">
                                        <div
                                            class="rounded-lg bg-white shadow-lg md:shadow-xl relative overflow-hidden">
                                            <div class="px-3 pt-8 pb-10 text-center relative z-10">
                                                <div class="bank-logo mb-2">
                                                    <img src="<?php echo e(asset('img/') . env('SYSTEM_LOGO')); ?>" alt="">
                                                </div>
                                                <h3 class="text-3xl text-black font-semibold leading-tight my-3 text-success" style="background-color: rgba(0,0,0,0.1);">
                                                    <?php echo e(isset($uofsfinancial) ? $uofsfinancial : 0.0); ?>

                                                </h3>
                                                <h4 class="text-black leading-tight text-xl p-1 rounded-2" style="background-color: rgba(14,197,235, 0.5);">
                                                    إيرادات المحاسبين
                                                </h4>
                                            </div>
                                            <div class="absolute bottom-0 inset-x-0">
                                                <canvas id="chart2" height="70"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                        <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://unpkg.com/flowbite@1.5.2/dist/flowbite.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/httpsunited/public_html/shemal.united.sd/resources/views/home.blade.php ENDPATH**/ ?>