<nav class="bg-white px-2 sm:px-4 py-2.5 dark:bg-gray-900 fixed w-full z-20 top-0 left-0 border-b border-gray-200 dark:border-gray-600">
    <div class="container flex flex-wrap justify-between items-center mx-auto">
        <a href="<?php echo e(route('home')); ?>" id="dashboard" class="flex items-center">
            <img src="<?php echo e(asset('img/') . config('system.logo')); ?>" alt="">
        </a>
        <div class="flex md:order-2">
            <div type="button" class="text-gray-700 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center mr-3 md:mr-0 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <ul class="navbar-nav <?php echo e(App::isLocale('ar') ? '' : 'ms-auto'); ?>">
                    <!-- Authentication Links -->
                    <?php if(auth()->guard()->guest()): ?>
                        <?php if(Route::has('login')): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('login.login')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(Route::has('register')): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('login.registrar')); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                               data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php echo e(Auth::user()->name); ?>

                            </a>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item text-right" href="<?php echo e(route('user.profile')); ?>">
                                    الملف الشخصي
                                </a>
                                <?php if(auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin')): ?>
                                    <a class="dropdown-item text-right" href="<?php echo e(route('registration-management.index')); ?>">
                                        ادارة التسجيل
                                    </a>
                                <?php endif; ?>
                                <a class="dropdown-item text-right" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                            document.getElementById('logout-form').submit();">
                                    <?php echo e(__('login.logout')); ?>

                                </a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>

            <button data-collapse-toggle="navbar-sticky" type="button"
                    class="inline-flex items-center p-2 text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600"
                    aria-controls="navbar-sticky" aria-expanded="false">
                <span class="sr-only">Open main menu</span>
                <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"
                     xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                          d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z"
                          clip-rule="evenodd"></path>
                </svg>
            </button>
        </div>
        <div class="hidden justify-between items-center w-full md:flex md:w-auto md:order-1" id="navbar-sticky">
            <ul class="flex flex-col bg-gray-50 rounded-lg border border-gray-100 md:flex-row md:space-x-8 md:mt-0 md:text-sm md:font-medium md:border-0 md:bg-white dark:bg-gray-800 md:dark:bg-gray-900 dark:border-gray-700"
                dir="rtl">
                <li>
                    <a href="<?php echo e(auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin') ? route('student.index') : '#'); ?>"
                       class="block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'student' && Request::segment(2) == '' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> bg-blue-700 rounded md:bg-transparent md:p-0 dark:text-white home-custom"
                       aria-current="page">
                        <?php echo e(__('home.students')); ?>

                    </a>
                </li>

                <li>
                    <a id="navbarDropdown"
                       data-dropdown-toggle="cards-managment"
                       class="nav-link dropdown-toggle block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'students-cards' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">
                        <?php echo e(__('student-card.students-cards')); ?>

                    </a>

                    <!-- Dropdown menu -->
                    <div id="cards-managment"
                         class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700">
                        <ul class="py-1 text-sm text-gray-700 dark:text-gray-200"
                            aria-labelledby="cardsManagment">
                            <li>
                                <a href="<?php echo e(route('students-cards.index')); ?>"
                                   class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'students-cards' && Request::segment(2) == '' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    إستخراج بطاقة جديدة
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('students-cards.replace-lost')); ?>"
                                   class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'students-cards' && Request::segment(2) == 'replace-lost' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    إستخراج بدل فاقد
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>



                <?php if(auth()->user()->hasRole('financial')): ?>
                    <li>
                        <a href="<?php echo e(route('pay.student.payment')); ?>"
                           class="block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'student' && Request::segment(2) == 'payments' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700"
                           aria-current="page">
                            <?php echo e(__('fee.pay-new-fee')); ?>

                        </a>
                    </li>
                <?php endif; ?>

                <li>
                    <a id="navbarDropdown"
                       data-dropdown-toggle="fees-managment"
                       class="nav-link dropdown-toggle block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'fee' || Request::segment(1) == 'other-fee' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">
                        إدارة الدفعيات
                    </a>

                    <!-- Dropdown menu -->
                    <div id="fees-managment"
                         class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700">
                        <ul class="py-1 text-sm text-gray-700 dark:text-gray-200"
                            aria-labelledby="feesManagment">
                            <li>
                                <a href="<?php echo e(auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin') ? route('fee.index') : '#'); ?>"
                                   class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'fee' && Request::segment(2) == '' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    إدارة دفعيات الطلاب
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin') ? route('other-fee.index') : '#'); ?>"
                                   class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'other-fee' && Request::segment(2) == '' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    إدارة دفعيات غير الطلاب
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <?php if(auth()->user()->hasRole(['registrar', 'admin'])): ?>
                    <li>
                        <a id="navbarDropdown"
                           data-dropdown-toggle="attendance-menus-dropdown"
                           class="nav-link dropdown-toggle block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'attendance' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">
                            <?php echo e(__('home.attendance-menus')); ?>

                        </a>

                        <!-- Dropdown menu -->
                        <div id="attendance-menus-dropdown"
                             class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700">
                            <ul class="py-1 text-sm text-gray-700 dark:text-gray-200"
                                aria-labelledby="attendancemenus">
                                <li>
                                    <a href="<?php echo e(route('attendances.classes-attendance-sheet')); ?>" class="block py-2 px-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'attendance' && Request::segment(2) == 'classes-attendance-sheet' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('home.classes-attendance-sheet')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('attendances.exams-attendance-sheet')); ?>" class="block py-2 px-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'attendance' && Request::segment(2) == 'exams-attendance-sheet' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('home.exams-attendance-sheet')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <li>
                    <a id="navbarDropdown"
                       data-dropdown-toggle="reports-dropdown"
                       class="nav-link dropdown-toggle block py-2 pr-4 pl-3 <?php echo e(Request::segment(1) == 'reports' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?> rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">
                        <?php echo e(__('home.reports')); ?>

                    </a>

                    <!-- Dropdown menu -->
                    <div id="reports-dropdown"
                         class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700">
                        <ul class="py-1 text-sm text-gray-700 dark:text-gray-200"
                            aria-labelledby="dropdownDefault">
                            <li>
                                <a href="<?php echo e(route('reports.payments')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'reports' && Request::segment(2) == 'payments' || Request::segment(2) == 'filter-students-payments-report' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    <?php echo e(__('report.students-payments')); ?>

                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('reports.fees')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'reports' && Request::segment(2) == 'fees' || Request::segment(2) == 'filter-students-fees-report' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                    <?php echo e(__('report.students-fees')); ?>

                                </a>
                            </li>

                            <?php if(auth()->user()->hasRole(['financial', 'admin'])): ?>
                                <li>
                                    <a href="<?php echo e(route('reports.revenues')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'reports' && Request::segment(2) == 'revenues' || Request::segment(2) == 'filter-students-revenues-report' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('report.students-revenues')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('reports.revenue-min')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'reports' && Request::segment(2) == 'revenues-min' || Request::segment(2) == 'filter-students-revenues-min-report' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('report.students-revenues-min')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>

                <li>
                    <a href="#" id="testimoniesCertificates"
                       class="block py-2 pr-4 pl-3 text-gray-700 rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">
                        <?php echo e(__('home.testimonies-certificates')); ?>

                    </a>
                </li>
                <li>
                    <a id="navbarDropdown"
                       data-dropdown-toggle="settings-dropdown"
                       class="nav-link dropdown-toggle block py-2 pr-4 pl-3 rounded hover:bg-gray-100 md:hover:bg-transparent md:hover:text-[#bd5668] md:p-0 md:dark:hover:text-white dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700 <?php echo e(Request::segment(1) == 'settings' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                        <?php echo e(__('home.settings')); ?>

                    </a>

                    <!-- Dropdown menu -->
                    <div id="settings-dropdown"
                         class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow dark:bg-gray-700">
                        <ul class="py-1 text-sm text-gray-700 dark:text-gray-200"
                            aria-labelledby="dropdownDefault">
                            <?php if(auth()->user()->hasRole('admin')): ?>
                                <li>
                                    <a href="<?php echo e(route('settings.registration.constraint')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'settings' && Request::segment(2) == 'registration-constraint' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        قيود التسجيل
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(auth()->user()->hasRole('registrar') || auth()->user()->hasRole('admin')): ?>
                                <li>
                                    <a href="<?php echo e(route('settings.setup.registration')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'settings' && Request::segment(2) == 'setup-registration' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('settings.setup-registration')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('settings.setup.penalty')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'settings' && Request::segment(2) == 'setup-penalty' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('settings.setup-penalty')); ?>

                                    </a>
                                </li>
                            <?php else: ?>
                                <li>&nbsp;</li>
                            <?php endif; ?>

                            <?php if(auth()->user()->hasRole('admin')): ?>
                                <li>
                                    <a href="<?php echo e(url('settings/sort-students')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'settings' && Request::segment(2) == 'sort-students' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('settings.manage-sort-students')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(url('users-management')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'users-management' && Request::segment(2) == 'roles-assignment' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('settings.users-management')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('settings.activity-log')); ?>" class="block py-2 px-4 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white <?php echo e(Request::segment(1) == 'settings' && Request::segment(2) == 'activity-log' ? 'text-blue-500 md:text-blue-700' : 'text-gray-700'); ?>">
                                        <?php echo e(__('settings.activities-log')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</nav>
<?php /**PATH /home/httpsunited/public_html/shemal.united.sd/resources/views/layouts/main/nav.blade.php ENDPATH**/ ?>