<?php $__env->startSection('styles'); ?>

<link href="<?php echo e(asset('plugins/bootstrap-editable/css/bootstrap-editable.css')); ?>" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="<?php echo e(asset('css/custom-student-style.css')); ?>">
<style>
    tfoot{
        background-color: #36304a;
    }

    table.dataTable>thead>tr>th:not(.sorting_disabled){
        padding-right: 30px !important;
    }
</style>

<style>
    .registration-lable {
        color: #a72035;
        font-weight: 900;
    }
    tfoot{
        background-color:#36304a !important;
    }
    tfoot p{
        color: white !important;
        font-size: 12px !important;
        font-weight: 100 !important;
    }
</style>

<link rel="stylesheet" href="<?php echo e(asset('css/custom-student-style.css')); ?>">

<style>
    .html5buttons {
        direction: ltr;
        position: absolute;
        top: -45px;
        left: 10px;
    }

    .html5buttons .btn-secondary {
        color: #ffffff;
        background-color: #295694;
    }

    .html5buttons .buttons-print,
    .html5buttons .buttons-excel {
        background-color: rgb(167, 32, 53);
        color: white;
    }

    .dataTables_filter {
        margin: 20px 0px 20px;
    }

    #min,
    #max {
        max-width: 150px;
        min-width: unset;
        font-size: 12px;
        font-weight: 400;
        text-align: center;
        color: #495057;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #ced4da !important;
        border-radius: 0.25rem;
        min-height: calc(1.5em + 0.5rem + 2px);
        padding: 0.25rem 0.5rem;
    }

    .dt-datetime-year,
    .dt-datetime-month {
        min-width: unset !important;
        width: 50px !important;
        max-height: 22px !important;
    }

    input[type='date'],
    input[type='date']:focus-visible,
    input[type='date']:focus{
        min-width: unset;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="padding-top: 53px;">
    <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
        <div class="flex justify-center items-start p-4 rounded-t border-b dark:border-gray-600">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                <?php echo e(__('settings.setup-registration')); ?>

            </h3>
            
        </div>
        <div class="p-6 space-y-6">
            <div class="card-body">
                <!-- filter -->
                <?php echo $__env->make('layouts.filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div id="studentsListTable" class="mt-4">
                    <table class="table" id="studentsTable" style="width: 100%;">
                        <thead>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.id')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.name')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.college')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.section')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.program')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.batch')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.registration-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.tuition-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.insurance-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white" style="min-width: 100px;">
                                    <?php echo e(__('student.show')); ?>

                                </th>
                            </tr>
                        </thead>
                        <tbody id="studentsList">
                            <?php if(isset($students) && $students != '[]'): ?>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="bg-white border-b dark:bg-gray-900 dark:border-gray-700">
                                        <th scope="row" class="py-2 text-center font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                            <?php echo e($student->student_id); ?>

                                        </th>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->student_name); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->college ? $student->college->name : __('student.not-set')); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->section->name ?? __('student.not-set')); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->program->name ?? __('student.not-set')); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->batch ? $student->batch->value : __('student.not-set')); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->registration_fees); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->program_fees); ?>

                                        </td>
                                        <td class="py-2 text-center">
                                            <?php echo e($student->insurance_fees); ?>

                                        </td>
                                        <td class="py-2 text-center showStudent">
                                            <a class="px-4 py-1 text-sm text-white bg-blue-700 hover:bg-blue-800 rounded-full"
                                                href="<?php echo e(route('student.edit', $student->id)); ?>" style="background-color: #36304a">
                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                                <?php echo e(__('student.show')); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.id')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.name')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.college')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.section')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.program')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.batch')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.registration-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.tuition-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.insurance-fees')); ?>

                                </th>
                                <th scope="col" class="py-2 px-2 text-white">
                                    <?php echo e(__('student.show')); ?>

                                </th>
                            </tr>
                        </tfoot>
                    </table>

                    <div>
                        <?php echo e($students->withQueryString()->links()); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="p-6 space-y-6">
            <div class="card-body">
                <form action="<?php echo e(route('registration.store')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <input type="hidden" name="college_id" value="<?php echo e(request()->college_id); ?>">
                    <input type="hidden" name="batch_id" value="<?php echo e(request()->batch_id); ?>">
                    <input type="hidden" name="section_id" value="<?php echo e(request()->section_id); ?>">
                    <input type="hidden" name="program_id" value="<?php echo e(request()->program_id); ?>">
                    <input type="hidden" name="semester" value="<?php echo e($semester_id ?? null); ?>">


                    <div class="justify-center py-6 row space-x-4">
                        <div class="col-2 pt-2 ml-4">
                            <?php echo e(__('settings.registration-start')); ?>

                            <input type="date" name="registration_start" id="registrationStart" required
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 px-1">
                        </div>

                        <div class="col-2 pt-2">
                            <?php echo e(__('settings.registration-end')); ?>

                            <input type="date" name="registration_end" id="registrationEnd" required
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        </div>
                        <div class="col-2 pt-2">
                            &nbsp;
                            <select id="semester" name="semester_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                                <option value="0"><?php echo e(__('student.choose-semester')); ?></option>
                                <?php if( isset($semesters) ): ?>
                                <?php $__currentLoopData = $semesters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($semester->id); ?>">
                                    <?php echo e($semester->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <div class="justify-center py-6 row space-x-4">
                        <div class="col-2 pt-2">
                            <div class="flex mb-1">
                                <span class="mx-auto">
                                    مقدار الدمغة
                                </span>
                            </div>
                            <input type="text" name="stamp" id="registrationEnd" required
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 text-center mx-auto"
                                value="50"
                                style="width: 100px;">
                        </div>

                    </div>

                    <div class="row flex justify-center space-x-2 mt-4">
                        <div class="col-4 flex justify-center px-1 pb-16">
                            <button type="submit" style="background-color: #36304a;" class="mr-3 px-5 py-2 rounded-2 text-white btn" id="studentRegistration" name="registration">
                                <?php echo e(__('settings.start-registration')); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php echo Toastr::message(); ?>


<script src="<?php echo e(asset('plugins/jQuery.print.min.js')); ?>"></script>

<script src="<?php echo e(asset('plugins/jquery-validate/js/jquery.validate.min.js')); ?>"></script>

<script>
    $(document).ready(function () {
        dataTable = $("#studentsTable2").DataTable({
            "responsive": false,
            "lengthChange": false,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "ordering": true,
            "info": false,
            "deferRender": true,
            // "buttons": ["copyHtml5", "csv", "excel", "pdf", "print", "colvis"],

            "oLanguage": {
                "sSearch": "بحث ",
                "sEmptyTable": "لا توجد بيانات متوفرة في الجدول",
            },
        });

        $('#college, #section, #program, #batch, #paymentCurrency').each( function (){
            $(this).change(function (e) {
                e.preventDefault();

                $('#studentFilter').click();
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/httpsunited/public_html/shemal.united.sd/resources/views/settings/setup-registration.blade.php ENDPATH**/ ?>